DROP PROCEDURE [hips].[HealthProviderIndividualUpdate]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon
-- Create date: 16 October 2012
-- Description:   Updates a record into the HealthProviderIndividuals Table
-- =============================================
CREATE PROCEDURE [hips].[HealthProviderIndividualUpdate] 
(
	@HealthProviderIndividualId INT,
	@IamProviderIdentifier VARCHAR(30) = NULL,
    @HpiI VARCHAR(16) = NULL,
    @HpiILastValidatedDate DATETIME = NULL,
    @TitleId INT = NULL,
    @FamilyName VARCHAR(80),
    @GivenNames VARCHAR (100),
    @SuffixId INT = NULL,
	@UserModified varchar(256),
	@DateModified datetime
)
AS
BEGIN
    SET NOCOUNT ON
 DECLARE @intErrorCode int

    SET @intErrorCode = 0

    IF NOT EXISTS (SELECT TOP 1 [DateModified]
            	FROM [hips].[HealthProviderIndividual]
				WHERE [HealthProviderIndividualId] = @HealthProviderIndividualId AND [DateModified] = @DateModified)
    BEGIN
        RAISERROR 50001 'Record has already been updated!'
        SET @intErrorCode = @@ERROR
    END
 IF @intErrorCode = 0
    BEGIN
        UPDATE [hips].[HealthProviderIndividual]
           SET [IamProviderIdentifier] = @IamProviderIdentifier
            ,[HpiI] = @HpiI
            ,[HpiILastValidatedDate] = @HpiILastValidatedDate
			,[TitleId] = @TitleId
			,[FamilyName] = @FamilyName
			,[GivenNames] = @GivenNames
			,[SuffixId] = @SuffixId
            ,[DateModified] = GetDate()
            ,[UserModified] = @UserModified
         WHERE [HealthProviderIndividualId] = @HealthProviderIndividualId

        SELECT @intErrorCode = @@ERROR
    END

    IF @intErrorCode = 0
    BEGIN
		SELECT
			hcp.HealthProviderIndividualId,
			hcp.IamProviderIdentifier,
			hcp.HpiI,
			hcp.HpiILastValidatedDate,
			hcp.TitleId,
			t.Description AS Title,
			hcp.FamilyName,
			hcp.GivenNames,
			hcp.SuffixId,
			s.Description AS Suffix,
			hcp.[DateCreated],
            hcp.[UserCreated],
            hcp.[DateModified],
            hcp.[UserModified]

		FROM hips.HealthProviderIndividual AS hcp
		JOIN hips.Title AS t ON t.TitleId = hcp.TitleId
		LEFT OUTER JOIN hips.Suffix AS s ON s.SuffixId = hcp.SuffixId
		WHERE [HealthProviderIndividualId] = @HealthProviderIndividualId

    END

    RETURN(@intErrorCode)
END
GO

